using System;
using System.Collections;
using System.Reflection;
using System.Drawing;

using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox; 


namespace DarkStride.StellarLanes.SharedDLL
{
	public class Starscape
	{
		#region Variables
		private DSGameEngine m_oGameEngine = null;

		private VertexBuffer m_oStarVertexBuffer = null;
		private struct PointVertex
		{
			public Vector3 v;
			public int color;
			public static readonly Microsoft.DirectX.Direct3D.VertexFormats Format =  VertexFormats.Position | VertexFormats.Diffuse;
		};
		private ArrayList[] m_oStars = new ArrayList[ 4 ];
		private int m_nBaseParticle	= 2048;
		#endregion


		public Starscape( DSGameEngine oGameEngine )
		{
			m_oGameEngine = oGameEngine;
			RandomizeStars();
		}
        
		public void RandomizeStars()
		{
			Vector2 vStarPos = Vector2.Empty;


			//Advance our stars
			for( int nClusterIdx=0 ; nClusterIdx<m_oStars.Length ; nClusterIdx++ )
			{
				//Create pir base stars of we meed to
				m_oStars[ nClusterIdx ] = new ArrayList();
				for( int nStarIdx=0 ; nStarIdx<200 ; nStarIdx++ )
				{
					vStarPos = new Vector2( 
								(float)( DSMisc.GetRnd() * m_oGameEngine.ScreenWidth ),
								(float)( DSMisc.GetRnd() * m_oGameEngine.ScreenHeight ) );
					m_oStars[ nClusterIdx ].Add( vStarPos );
				}
			}
		}
		public void AdjustZoomLevel( double nPercentZoomChange )
		{
			int nIndex = 0;
			int nRnd = 0;
			double nDeltaX = 0, nDeltaY = 0;
            double nPercChange = 0;
            double nRndArea = 0;
            double nTotalArea = 0;
            double nTempArea = 0;
			Vector2 vStarPos = Vector2.Empty;
            System.Drawing.Rectangle oSpot = System.Drawing.Rectangle.Empty;
            System.Collections.Generic.List<System.Drawing.Rectangle> oaSpotsToFill = null;


            nPercChange = (m_oGameEngine.ScreenWidth / 2.0) / 
                    ((m_oGameEngine.ScreenWidth / 2.0) * nPercentZoomChange);
             
			//Make the change for each star field
			for( int nClusterIdx=0 ; nClusterIdx<m_oStars.Length ; nClusterIdx++ )
			{
				for( int nStarIdx=0 ; nStarIdx<m_oStars[ 0 ].Count ; nStarIdx++ )
				{
					vStarPos = (Vector2)m_oStars[nClusterIdx][nStarIdx];
					nDeltaX = vStarPos.X - ( m_oGameEngine.ScreenWidth / 2.0 );
					nDeltaY = vStarPos.Y - ( m_oGameEngine.ScreenHeight / 2.0 );

					//Move this star towords the center
					if( nPercentZoomChange > 1 )
					{
                        m_oStars[nClusterIdx][nStarIdx] = new Vector2(
                            (float)(m_oGameEngine.ScreenWidth / 2.0 + nDeltaX * nPercChange),
                            (float)(m_oGameEngine.ScreenHeight / 2.0 + nDeltaY * nPercChange));
					}
					else
					{
						m_oStars[nClusterIdx][nStarIdx] = new Vector2( 
							(float)( m_oGameEngine.ScreenWidth / 2.0 + nDeltaX * (1+1-nPercentZoomChange) ),
							(float)( m_oGameEngine.ScreenHeight / 2.0 + nDeltaY * (1+1-nPercentZoomChange) ) );
					}
				}
			}

			//In this case we are zooming out, so we have space to fill in 
			if( nPercentZoomChange > 1 )
			{
                //Calculate our areas needing new stars
                oaSpotsToFill = GetZoomInSpots( nPercChange );
                nTotalArea = CalculateVolume( oaSpotsToFill );

				//Make the change for each star field
				for( int nClusterIdx=0 ; nClusterIdx<m_oStars.Length ; nClusterIdx++ )
				{
					for( int i=0 ; i<( nPercentZoomChange-1 )*m_oStars[ nClusterIdx ].Count ; i++ )
					{
						//Pick a random star
						nIndex = DSMisc.GetRnd( 0,m_oStars[nClusterIdx].Count-1 );
						nRndArea = DSMisc.GetRnd( 0,nTotalArea );

                        //Find which rect this spot falls into
                        nTempArea = 0;
                        nRnd = 0;
                        foreach( System.Drawing.Rectangle oLoopRect in oaSpotsToFill )
                        {
                            nTempArea += oLoopRect.Height * oLoopRect.Width;
                            if( nRndArea <= nTempArea )
                            {
                                break;
                            }
                            nRnd++;
                        }
                        if (nRnd >= 4 )
                        {
                            throw new System.Exception("Unable to find spot for new star.");
                        }

						//Now place our star
                        oSpot = oaSpotsToFill[nRnd];

						m_oStars[nClusterIdx][nIndex] = new Vector2( 
							(float)DSMisc.GetRnd( oSpot.Left,oSpot.Right ),
                            (float)DSMisc.GetRnd( oSpot.Top,oSpot.Bottom ) );
					}
				}
			}
			//Now we are zooming in so we have stars we can no longer see
			else if( nPercentZoomChange < 1 )
			{
				//Make the change for each star field
				for( int nClusterIdx=0 ; nClusterIdx<m_oStars.Length ; nClusterIdx++ )
				{
					for( int nStarIdx=0 ; nStarIdx<m_oStars[ nClusterIdx ].Count ; nStarIdx++ )
					{
						vStarPos = (Vector2)m_oStars[nClusterIdx][nStarIdx];
						if( vStarPos.X > m_oGameEngine.ScreenWidth || vStarPos.X < 0 ||
							vStarPos.Y > m_oGameEngine.ScreenHeight || vStarPos.Y < 0 )
						{
							m_oStars[ nClusterIdx ][ nStarIdx ] = new Vector2( 
											(float)DSMisc.GetRnd( 0,m_oGameEngine.ScreenWidth ),
											(float)DSMisc.GetRnd( 0,m_oGameEngine.ScreenHeight ) );
						}
					}
				}
			}
		}

        private System.Collections.Generic.List<System.Drawing.Rectangle> GetZoomInSpots( double nPercChange )
        {
            System.Collections.Generic.List<System.Drawing.Rectangle> oaSpotsToFill = new System.Collections.Generic.List<System.Drawing.Rectangle>();
            System.Drawing.Rectangle oSpot = System.Drawing.Rectangle.Empty;

            //Top
            oSpot = GetRect( 0,0,m_oGameEngine.ScreenWidth,
                            (int)((m_oGameEngine.ScreenHeight / 2.0) - (m_oGameEngine.ScreenHeight / 2.0) * nPercChange));
            oaSpotsToFill.Add( oSpot );
            //Bottom
            oSpot = GetRect( 0,
                            (int)((m_oGameEngine.ScreenHeight / 2.0) + (m_oGameEngine.ScreenHeight / 2.0) * nPercChange),
                            m_oGameEngine.ScreenWidth,m_oGameEngine.ScreenHeight);
            oaSpotsToFill.Add( oSpot );
            //Left
            oSpot = GetRect( 0,
                            (int)((m_oGameEngine.ScreenHeight / 2.0) - (m_oGameEngine.ScreenHeight / 2.0) * nPercChange),
                            (int)((m_oGameEngine.ScreenWidth / 2.0) - (m_oGameEngine.ScreenWidth / 2.0) * nPercChange),
                            (int)((m_oGameEngine.ScreenHeight / 2.0) + (m_oGameEngine.ScreenHeight / 2.0) * nPercChange));
            oaSpotsToFill.Add( oSpot );
            //Right
            oSpot = GetRect((int)((m_oGameEngine.ScreenWidth / 2.0) + (m_oGameEngine.ScreenWidth / 2.0) * nPercChange),
                            (int)((m_oGameEngine.ScreenHeight / 2.0) - (m_oGameEngine.ScreenHeight / 2.0) * nPercChange),
                            m_oGameEngine.ScreenWidth,
                            (int)((m_oGameEngine.ScreenHeight / 2.0) + (m_oGameEngine.ScreenHeight / 2.0) * nPercChange));
            oaSpotsToFill.Add( oSpot );


            return(oaSpotsToFill);
        }
        private double CalculateVolume( System.Collections.Generic.List<System.Drawing.Rectangle> oaRects )
        {
            double nTotalVol = 0;

            foreach( System.Drawing.Rectangle oLoopRect in oaRects )
            {
                nTotalVol += oLoopRect.Width * oLoopRect.Height;
            }

            return( nTotalVol );
        }
        private System.Drawing.Rectangle GetRect( double nX1,double nY1,double nX2,double nY2 )
        {
            System.Drawing.Rectangle oSpot = System.Drawing.Rectangle.Empty;
            oSpot = new System.Drawing.Rectangle( (int)nX1,(int)nY1,(int)(nX2-nX1),(int)(nY2-nY1) );
            return( oSpot );
        }

		public void AdvanceStarScape( double nCurrentZoom,Vector2 vDeltaMotion )
		{
			int nCenterX = (int)( m_oGameEngine.ScreenWidth / 2.0f );
			int nCenterY = (int)( m_oGameEngine.ScreenHeight / 2.0f );
			Vector2 vDelta = Vector2.Empty;
			Vector2 vTemp = Vector2.Empty;


			//Advance our stars
			for( int nClusterIdx=0 ; nClusterIdx<m_oStars.Length ; nClusterIdx++ )
			{
				for( int nStarIdx=0 ; nStarIdx<m_oStars[ nClusterIdx ].Count ; nStarIdx++ )
				{
					if( nStarIdx>=m_oStars[ nClusterIdx ].Count ){ break; }

					vTemp = (Vector2)m_oStars[ nClusterIdx ][ nStarIdx ];
					vDelta = new Vector2( vDeltaMotion.X * ( .55f - .15f * nClusterIdx ) * (float)nCurrentZoom,
										  vDeltaMotion.Y * ( .55f - .15f * nClusterIdx ) * (float)nCurrentZoom );
					m_oStars[ nClusterIdx ][ nStarIdx ] = new Vector2( vTemp.X - vDelta.X,
																	   vTemp.Y - vDelta.Y );
					vTemp = (Vector2)m_oStars[ nClusterIdx ][ nStarIdx ];

					if( vTemp.X < - 10 )
					{
						m_oStars[ nClusterIdx ][ nStarIdx ] = new Vector2( 
								(float)DSMisc.GetRnd( m_oGameEngine.ScreenWidth,m_oGameEngine.ScreenWidth + 10 ),
								vTemp.Y );
					}
					if( vTemp.X > m_oGameEngine.ScreenWidth + 10 )
					{
						m_oStars[ nClusterIdx ][ nStarIdx ] = new Vector2( 
								DSMisc.GetRnd( 0,0 - 10 ),
								vTemp.Y );
					}
					if( vTemp.Y < - 10 )
					{
						m_oStars[ nClusterIdx ][ nStarIdx ] = new Vector2( 
								vTemp.X,
								(float)DSMisc.GetRnd( m_oGameEngine.ScreenHeight,m_oGameEngine.ScreenHeight + 10 ) );
					}
					if( vTemp.Y > m_oGameEngine.ScreenHeight + 10 )
					{
						m_oStars[ nClusterIdx ][ nStarIdx ] = new Vector2( 
								vTemp.X,
								DSMisc.GetRnd( 0,0 - 10 ) );
					}
				}
			}
		}
		public void RenderStarScape()
		{
			RenderStarScape( System.Drawing.Rectangle.Empty );
		}
		public void RenderStarScape( System.Drawing.Rectangle oValidScreenBounds )
		{
			int nDiscard = 2048;
			int nFlush = 512;
			PointVertex[] vertices = null;
			int numParticlesToRender = 0;
			int count = 0;
			Vector3 vPos;
			string sCaptureBlockKey = "Star Scape Capture Block";
			Texture oTexture = null;
			Microsoft.DirectX.Direct3D.Device o3DDevice = m_oGameEngine.Direct3DDevice;


			//o3DDevice.RenderState.Lighting = false;
			m_oGameEngine.CaptureStateBlock( sCaptureBlockKey );


			if( m_oStarVertexBuffer == null )
			{
				m_oStarVertexBuffer = new VertexBuffer(typeof(PointVertex), nDiscard, o3DDevice,  Usage.Dynamic | Usage.WriteOnly | Usage.Points, PointVertex.Format, Pool.Default);
			}


			o3DDevice.RenderState.Lighting = false;
			o3DDevice.SetTransform( TransformType.World,Matrix.Identity );
			o3DDevice.SetTransform( TransformType.View,Matrix.Identity );
			o3DDevice.SetTransform( TransformType.Projection,
							Matrix.OrthoOffCenterLH( 0,m_oGameEngine.ScreenWidth,m_oGameEngine.ScreenHeight,0,0,1000 ) );

			oTexture = DSResourceManager.GetGlobalInstance().GetTexture( "Star Particle Texture" );
			//oTexture = DSResourceManager.GetGlobalInstance().GetTexture( "System_Particle" );
			o3DDevice.SetTexture(0, oTexture);

			// Set up the vertex buffer to be rendered
			o3DDevice.SetStreamSource(0, m_oStarVertexBuffer, 0);
			o3DDevice.VertexFormat = PointVertex.Format;

			o3DDevice.RenderState.ZBufferWriteEnable = false;
			o3DDevice.RenderState.AlphaBlendEnable = true;
			o3DDevice.RenderState.SourceBlend = Blend.One;
			o3DDevice.RenderState.DestinationBlend = Blend.One;

			o3DDevice.SetTextureStageState( 0, TextureStageStates.ColorOperation, (int)TextureOperation.Disable );
			o3DDevice.SetTextureStageState( 0, TextureStageStates.AlphaOperation, (int)TextureOperation.Disable );
			o3DDevice.SetTextureStageState( 1, TextureStageStates.ColorOperation, (int)TextureOperation.Disable );
			o3DDevice.SetTextureStageState( 1, TextureStageStates.AlphaOperation, (int)TextureOperation.Disable );


			//Set the render states for using point sprites
			o3DDevice.RenderState.PointSpriteEnable = true;
			o3DDevice.RenderState.PointScaleEnable = false;
			o3DDevice.RenderState.PointSize = 1.0f;// + (float)Math.Floor( (float)m_nCurrentZoom / 4.0f );
			o3DDevice.RenderState.PointSizeMin = 0.00f;
			o3DDevice.RenderState.PointScaleA = 0.00f;
			o3DDevice.RenderState.PointScaleB = 0.00f;
			o3DDevice.RenderState.PointScaleC = 1.00f;


			// Lock the vertex buffer.  We fill the vertex buffer in small
			// chunks, using LockFlags.NoOverWrite.  When we are done filling
			// each chunk, we call DrawPrim, and lock the next chunk.  When
			// we run out of space in the vertex buffer, we start over at
			// the beginning, using LockFlags.Discard.
			m_nBaseParticle += nFlush;

			if (m_nBaseParticle >= nDiscard)
				m_nBaseParticle = 0;

			vertices = (PointVertex[])m_oStarVertexBuffer.Lock(m_nBaseParticle * DXHelp.GetTypeSize(typeof(PointVertex)), typeof(PointVertex), (m_nBaseParticle != 0) ? LockFlags.NoOverwrite : LockFlags.Discard, nFlush);

			int nColor = 0;
			for( int nClusterIdx=0 ; nClusterIdx<m_oStars.Length ; nClusterIdx++ )
			{
				if( m_oStars[nClusterIdx] == null ){ continue; }
					
				for( int nStarIdx=0 ; nStarIdx<m_oStars[nClusterIdx].Count ; nStarIdx++ )
				{
					Vector2 vStarPos = (Vector2)m_oStars[nClusterIdx][nStarIdx];

					/*if( oValidScreenBounds == System.Drawing.Rectangle.Empty ||
						(
							vStarPos.X < oValidScreenBounds.Right && 
							vStarPos.X > oValidScreenBounds.Left && 
							vStarPos.Y < oValidScreenBounds.Top && 
							vStarPos.Y > oValidScreenBounds.Bottom 
						)
					  )*/
					{
						if( nStarIdx< 1 )
						{
							nColor = System.Drawing.Color.FromArgb( 
								DSMisc.Max( 0,System.Drawing.Color.Yellow.R-nClusterIdx*40 ),
								DSMisc.Max( 0,System.Drawing.Color.Yellow.G-nClusterIdx*40 ),
								DSMisc.Max( 0,System.Drawing.Color.Yellow.B-nClusterIdx*40 ) ).ToArgb();
						}
						else if( nStarIdx<2 )
						{
							nColor = System.Drawing.Color.FromArgb( 
								DSMisc.Max( 0,System.Drawing.Color.Red.R-nClusterIdx*40 ),
								DSMisc.Max( 0,System.Drawing.Color.Red.G-nClusterIdx*40 ),
								DSMisc.Max( 0,System.Drawing.Color.Red.B-nClusterIdx*40 ) ).ToArgb();
						}
						else if( nStarIdx<3 )
						{
							nColor = System.Drawing.Color.FromArgb( 
								DSMisc.Max( 0,System.Drawing.Color.Blue.R-nClusterIdx*40 ),
								DSMisc.Max( 0,System.Drawing.Color.Blue.G-nClusterIdx*40 ),
								DSMisc.Max( 0,System.Drawing.Color.Blue.B-40-nClusterIdx*40 ) ).ToArgb();
						}
						else
						{
							nColor = System.Drawing.Color.FromArgb( 180-nClusterIdx*30,180-nClusterIdx*30,180-nClusterIdx*30 ).ToArgb();
						}

						float nCenterX = m_oGameEngine.ScreenWidth / 2.0f;
						float nCenterY = m_oGameEngine.ScreenHeight / 2.0f;
						vPos = new Vector3( nCenterX - ( nCenterX - vStarPos.X ),
											nCenterY - ( nCenterY - vStarPos.Y ), 0 );

						//Is this out of bounds?
						if( vPos.X >= 0 && vPos.X <= m_oGameEngine.ScreenWidth &&
							vPos.Y >= 0 && vPos.Y <= m_oGameEngine.ScreenHeight )
						{
							if( oValidScreenBounds == System.Drawing.Rectangle.Empty ||
								(
									vPos.X < oValidScreenBounds.Right && 
									vPos.X > oValidScreenBounds.Left && 
									vPos.Y < oValidScreenBounds.Bottom && 
									vPos.Y > oValidScreenBounds.Top
								)
							  )
							{
								vertices[count].v     = vPos;
								vertices[count].color = nColor;//System.Drawing.Color.FromArgb( 180,180,180 ).ToArgb();
								count++;

								if( ++numParticlesToRender == nFlush )
								{
									// Done filling this chunk of the vertex buffer.  Lets unlock and
									// draw this portion so we can begin filling the next chunk.
									m_oStarVertexBuffer.Unlock();
									o3DDevice.DrawPrimitives(PrimitiveType.PointList, m_nBaseParticle, numParticlesToRender);

									// Lock the next chunk of the vertex buffer.  If we are at the 
									// end of the vertex buffer, LockFlags.Discard the vertex buffer and start
									// at the beginning.  Otherwise, specify LockFlags.NoOverWrite, so we can
									// continue filling the VB while the previous chunk is drawing.
									m_nBaseParticle += nFlush;

									if( m_nBaseParticle >= nDiscard )
									{
										m_nBaseParticle = 0;
									}

									vertices = (PointVertex[])m_oStarVertexBuffer.Lock(m_nBaseParticle * DXHelp.GetTypeSize(typeof(PointVertex)), typeof(PointVertex), (m_nBaseParticle != 0) ? LockFlags.NoOverwrite : LockFlags.Discard, nFlush);
									count = 0;

									numParticlesToRender = 0;
								}
							}
						}
					}
				} 
			}

			// Unlock the vertex buffer
			m_oStarVertexBuffer.Unlock();
			// Render any remaining m_nNumParticles
			if (numParticlesToRender > 0)
				o3DDevice.DrawPrimitives(PrimitiveType.PointList, m_nBaseParticle, numParticlesToRender);



			// Reset render states
			o3DDevice.RenderState.PointSpriteEnable = false;
			o3DDevice.RenderState.PointScaleEnable = false;

			o3DDevice.RenderState.ZBufferWriteEnable = true;
			o3DDevice.RenderState.AlphaBlendEnable = false;



			m_oGameEngine.ApplyStateBlock( sCaptureBlockKey );
		}
	}
}
